/********************************************************************
**  Device:     A9139M0
**  File:		Delay.c
**  Target:		A9139M0
********************************************************************/

#include "system_A9139M0.h"

/**********************************************************
* Delay10ms @12.8MHz
**********************************************************/
void Delay10ms ( Uint32 n )
{
    SysTick->LOAD = ( ( ( SystemCoreClock / 100 ) * n ) - 1 ); //setting
    SysTick->VAL = 0; //clear counter
    SysTick->CTRL |=  ( 1 << 2 ) | ( 1 << 0 );
    while ( ( SysTick->CTRL & 0x10000 ) == 0 );
    SysTick->CTRL  = 0x10000;
    SysTick->CTRL = 0;
}

/**********************************************************
* Delay1ms @12.8MHz
**********************************************************/
void Delay1ms ( Uint32 n )
{
    SysTick->LOAD = ( ( ( SystemCoreClock / 1000 ) * n ) - 1 ); //setting
    SysTick->VAL = 0; //clear counter
    SysTick->CTRL |=  ( 1 << 2 ) | ( 1 << 0 );
    while ( ( SysTick->CTRL & 0x10000 ) == 0 );
    SysTick->CTRL  = 0x10000;
    SysTick->CTRL = 0;
}

/**********************************************************
* Delay100us @12.8MHz
**********************************************************/
void Delay100us ( Uint32 n )
{
    SysTick->LOAD = ( ( ( SystemCoreClock / 10000 ) * n ) - 50 ); //setting
    SysTick->VAL = 0; //clear counter
    SysTick->CTRL |=  ( 1 << 2 ) | ( 1 << 0 );
    while ( ( SysTick->CTRL & 0x10000 ) == 0 );
    SysTick->CTRL  = 0x10000;
    SysTick->CTRL = 0;
}

/**********************************************************
* Delay10us @12.8MHz
**********************************************************/
void Delay10us ( Uint32 n )
{
    SysTick->LOAD = ( ( ( SystemCoreClock / 100000 ) * n ) - 50 ); //setting
    SysTick->VAL = 0;//clear counter
    SysTick->CTRL |=  ( 1 << 2 ) | ( 1 << 0 );
    while ( ( SysTick->CTRL & 0x10000 ) == 0 );
    SysTick->CTRL  = 0x10000;
    SysTick->CTRL = 0;
}
